<?
  // Ten skrypt tworzy obrazek ze znakami

  $tableName = 'antiRobotData';

  Header("Content-type: image/png");

  session_start();

  include "db_connect.php";
  include "antiRobotFunc.php";

  $text = GenerateARSession($tableName);

  // Tworzymy obrazek o takich rozmiarach, aby przy uzywanych przez nas najwiekszych
  // znakach nadal wszystkie miescily si w jego zakresie
  $img = @imagecreatetruecolor(24 * strlen($text) + 15, 50);

  // Kolor ta jest losowy aby nieco utrudnic skanowanie
  srand(time());
  $los_kol = rand(0, 75);
  $black_color = imagecolorallocate($img, $los_kol, $los_kol, $los_kol);
  imagefill ( $img, 1,1, $black_color );

  // Stworzenie obrazkow liter i wklejenie ich
  for($i = 0; $i < strlen($text); $i++)
  {
    // Tworzymy obrazek dla pojedynczego znaku aby atwo byo nim manipulowa
    $img_letter = @imagecreatetruecolor(20, 20);

    // Kolor kazdego znaku jest losowy jednak tylko z pewnego scisle dobranego zakresu, aby oko ludzkie
    // na pewno moglo odroznic
    $los_kolor1 = rand(-60, 50);
    $los_kolor2 = rand(0, 110);
    $los_kolor3 = rand(0, 110);
    $letter_color = imagecolorallocate($img, 205 + $los_kolor1, 40 + $los_kolor2, 140 + $los_kolor3);

    // Wypelniamy obrazek tem
    imagefill ( $img_letter, 1,1, $black_color );
    imagestring($img_letter, 5, 0, 0,  $text[$i], $letter_color);

    // Kady znak ma losowe rozmiary z pewnego zakresu
    $los_width = rand(38, 60);
    $los_height = rand(32, 64);

    // Skalujemy znak do wylosowanych wczeniej rozmiarw i wstawiamy go w odpowiednie miejsce
    // na gwnym obrazku
    imagecopyresized ($img, $img_letter, $i * 25 + 5, 5, 0, 0, $los_width, $los_height, 20,20);
    imagecolordeallocate($img_letter, $letter_color);
    ImageDestroy($img_letter);
  }

  // wysyamy obrazek na wyjscie oraz zwalniamy zasoby
  imagecolordeallocate($img, $black_color);
  Imagepng($img);
  ImageDestroy($img);
?>